/**
* \file: HIDPointerDevice.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_POINTERLISTENER_H
#define AAUTO_POINTERLISTENER_H

#include <time.h>
#include "WaylandContext.h"
#include "InputSourceReport.h"

namespace adit { namespace aauto
{

class InputSourceReceiver;

class PointerListener : public WaylandContext::DeviceListener
{
public:
    static struct wl_pointer_listener Listener;

    PointerListener(InputReport& inInputReport, int inWidth, int inHeight, bool inVerbose);
    virtual ~PointerListener();

private:
    float x;
    float y;
    float width;
    float height;
    uint8_t buttons;
    bool verbose;

    static bool staticInitialized;

    InputReport& report;

    /* Wayland pointer listeners */
    static void handleEnter(void* inData, struct wl_pointer* inPointer, uint32_t inSerial,
            struct wl_surface* inSurface, wl_fixed_t inX, wl_fixed_t inY);
    static void handleLeave(void* inData, struct wl_pointer* inPointer, uint32_t inSerial,
            struct wl_surface* inSurface);
    static void handleMotion(void* inData, struct wl_pointer* inPointer, uint32_t inTime,
            wl_fixed_t inX, wl_fixed_t inY);
    static void handleButton(void* inData, struct wl_pointer* inPointer, uint32_t inSerial,
            uint32_t inTime, uint32_t inButton, uint32_t inState);
    static void handleAxis(void* inData, struct wl_pointer* inPointer, uint32_t inTime,
            uint32_t inAxis, wl_fixed_t inValue);
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_POINTERLISTENER_H */
